@extends($activeTemplate . 'layouts.master')
@section('content')

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Recharge</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
      :root {
        --primary: #8b4dff;
        --gradient-primary: linear-gradient(145deg, #FFA500, #f5c05e);
        --text-color: #222;
        --white: #ffffff;
      }

      body {
        margin: 0;
        padding: 0;
        font-family: 'Poppins', sans-serif;
        background: linear-gradient(to bottom, #FFA500, #e0eafc);
        min-height: 100vh;
        
        display: flex;
        justify-content: center;
        align-items: flex-start;
      }

      .container {
        width: 100%;
        max-width: 400px;
        padding: 20px;
        position: relative;
      }

      .top-bar {
        position: relative;
        height: 40px;
      }

      .back-btn {
        position: absolute;
        top: 0;
        left: 0;
        background: rgba(255, 255, 255, 0.15);
        border-radius: 50%;
        width: 36px;
        height: 36px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        backdrop-filter: blur(10px);
      }

      .back-btn svg {
        width: 20px;
        height: 20px;
        stroke: white;
      }

      .header {
        text-align: center;
        font-size: 20px;
        font-weight: 600;
        color: white;
        margin-top: 0;
        margin-bottom: 20px;
      }

      .balance-card {
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(10px);
        border-radius: 16px;
        padding: 16px;
        display: flex;
        align-items: center;
        color: white;
        box-shadow: 0 4px 30px rgba(0,0,0,0.1);
        margin-bottom: 20px;
      }

      .balance-card img {
        width: 40px;
        height: 40px;
        margin-right: 12px;
      }

      .balance-amount {
        font-size: 22px;
        font-weight: 700;
      }

      .balance-label {
        font-size: 13px;
        opacity: 0.8;
      }

      label {
        color: white;
        font-weight: 600;
        font-size: 14px;
      }

      input[type="number"] {
        width: 100%;
        padding: 15px;
        margin: 10px 0 20px 0;
        border-radius: 12px;
        border: none;
        outline: none;
        background: rgba(255,255,255,0.2);
        backdrop-filter: blur(10px);
        color: white;
        font-size: 16px;
      }

      input[type="number"]::placeholder {
        color: rgba(255, 255, 255, 0.6);
      }

      .quick-amount {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 10px;
        margin-bottom: 25px;
      }

      .amount-btn {
        background: rgba(255,255,255,0.25);
        backdrop-filter: blur(10px);
        padding: 12px;
        border-radius: 12px;
        text-align: center;
        color: #222;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
      }

      .amount-btn:hover,
      .amount-btn.active { /* Corrected CSS selector */
        background: var(--gradient-primary);
        color: white;
      }

      .gateway-section {
        margin-top: 20px;
      }

      .gateway-boxes {
        display: flex;
        gap: 12px;
        margin-top: 10px;
      }

      .gateway-box {
        flex: 1;
        background: rgba(255,255,255,0.2);
        backdrop-filter: blur(10px);
        padding: 10px;
        border-radius: 12px;
        text-align: center;
        cursor: pointer;
        transition: all 0.3s ease;
        font-weight: 600;
        color: #222;
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding-left: 20px;
        padding-right: 20px;
      }

      .gateway-box.selected {
        background: var(--gradient-primary);
        color: white;
      }

      .gateway-box input[type="radio"] {
        accent-color: #fff;
        transform: scale(1.2);
      }

      .recharge-btn {
        width: 100%;
        padding: 16px;
        border: none;
        background: var(--gradient-primary);
        color: white;
        font-size: 18px;
        font-weight: bold;
        border-radius: 16px;
        cursor: pointer;
        margin-top: 30px;
        box-shadow: 0 6px 12px rgba(0,0,0,0.15);
      }

      .recharge-btn:disabled {
        background: #cccccc;
        cursor: not-allowed;
      }
    </style>
</head>

<body>
 <div class="container">
 <div class="top-bar">
 <div class="back-btn" onclick="history.back()">
 <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
 <polyline points="15 18 9 12 15 6"></polyline>
 </svg>
 </div>
 <div class="header">Recharge</div>
 </div>

 <div class="balance-card">
 <img src="https://i.ibb.co/Rkd5c2x0/photo-2025-08-05-21-55-52-removebg-preview.png" alt="Coin" />
 <div>
        {{-- Show user's actual balance --}}
 <div class="balance-amount">₹{{ showAmount(auth()->user()->deposit_wallet) }} {{ $general->cur_text }}</div>
 <div class="balance-label">Deposit Balance</div>
 </div>
 </div>

 <form id="rechargeForm">
 <label for="amount">Enter Amount</label>
 <input type="number" id="amount" placeholder="Recharge Amount Min ₹100" min="100" required />

 <label>Quick Amount</label>
 <div class="quick-amount">
 <div class="amount-btn" data-value="100">₹100</div>
 <div class="amount-btn" data-value="300">₹300</div>
 <div class="amount-btn" data-value="500">₹500</div>
 <div class="amount-btn" data-value="1000">₹1000</div>
 <div class="amount-btn" data-value="2000">₹2000</div>
 <div class="amount-btn" data-value="5000">₹5000</div>
 <div class="amount-btn" data-value="10000">₹10000</div>
 <div class="amount-btn" data-value="15000">₹15000</div>
 <div class="amount-btn" data-value="20000">₹20000</div>

 </div>

 <div class="gateway-section">
 <label>Online Channel</label>
 <div class="gateway-boxes">
 <div class="gateway-box selected">
 <span>Super-Pay</span>
 <input type="radio" name="gateway" value="PAY-A" checked />
 </div>
 <div class="gateway-box">
 <span>7 DAYS</span>
 <input type="radio" name="gateway" value="7Days" />
 </div>
 </div>
 </div>

 <button type="submit" class="recharge-btn" id="submitBtn" disabled>Recharge Now</button>
 </form>
 </div>

<script>
    const amountInput = document.getElementById("amount");
    const submitBtn = document.getElementById("submitBtn");

    validateAmount();

    document.querySelectorAll(".amount-btn").forEach((btn) => {
        btn.addEventListener("click", () => {
            document.querySelectorAll(".amount-btn").forEach((b) => b.classList.remove("active"));
            btn.classList.add("active");
            const value = parseInt(btn.dataset.value);
            amountInput.value = value;
            validateAmount();
        });
    });

    amountInput.addEventListener("input", () => {

        const currentInputValue = parseInt(amountInput.value);
        let buttonSelected = false;
        document.querySelectorAll(".amount-btn").forEach((btn) => {
            if (parseInt(btn.dataset.value) === currentInputValue) {
                btn.classList.add("active");
                buttonSelected = true;
            } else {
                btn.classList.remove("active");
            }
        });
        validateAmount();
    });

    function validateAmount() {
        const value = parseInt(amountInput.value);
        submitBtn.disabled = isNaN(value) || value < 100;
    }

    document.querySelectorAll(".gateway-box").forEach((box) => {
        box.addEventListener("click", () => {
            document.querySelectorAll(".gateway-box").forEach((b) => {
                b.classList.remove("selected");
                b.querySelector("input").checked = false;
            });
            box.classList.add("selected");
            box.querySelector("input").checked = true;
        });
    });

    document.getElementById("rechargeForm").addEventListener("submit", function (e) {
        e.preventDefault();
        
        const userPhone = '{{ auth()->user()->username ?? '' }}';

        const amount = amountInput.value;

        const paymentUrl = "https://crypto365.live/gwinyt/pay.php";

        if (!userPhone) {
            alert("Error: Could not find your phone number. Please update your profile and try again.");
            return;
        }

        const redirectUrl = `${paymentUrl}?phone=${encodeURIComponent(userPhone)}&amount=${encodeURIComponent(amount)}`;

        window.location.href = redirectUrl;
    });
</script>

</body>
</html>
@endsection

{{-- Your other scripts can be pushed here if needed --}}
@push('script')
<script>

    (function($) {
        "use strict";
    })(jQuery);
</script>
@endpush