<?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="col-lg-4 col-md-6">
        <div class="pricing-item">
            <div class="pricing-item__header">
                <span class="package__price text-shadow"><?php echo e(@$data->name); ?></span>
                <div class="package__offer text-shadow">
                    <?php if($data->fixed_amount == 0): ?>
                        <?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($data->minimum)); ?> -
                        <?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($data->maximum)); ?>

                    <?php else: ?>
                        <?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($data->fixed_amount)); ?>

                    <?php endif; ?>
                </div>
            </div>
            <div class="pricing-item__content">
                <ul class="package__feature-list">
                    <li class="text-shadow"> <?php echo app('translator')->get('Return'); ?>
                        <?php echo e(showAmount($data->interest)); ?><?php echo e($data->interest_type == 1 ? '%' : ' ' . __($general->cur_text)); ?>

                    </li>
                    <li class="text-shadow"><?php echo app('translator')->get('Every'); ?> <?php echo e(__($data->timeSetting->name)); ?></li>
                    <li class="text-shadow"> <?php echo app('translator')->get('For'); ?> <?php if($data->lifetime == 0): ?>
                            <?php echo e(__($data->repeat_time)); ?>

                            <?php echo e(__($data->timeSetting->name)); ?>

                        <?php else: ?>
                            <?php echo app('translator')->get('Lifetime'); ?>
                        <?php endif; ?>
                    </li>
                    <li class="text-shadow">
                        <?php if($data->lifetime == 0): ?>
                            <?php echo app('translator')->get('Total'); ?>
                            <?php echo e(__($data->interest * $data->repeat_time)); ?><?php echo e($data->interest_type == 1 ? '%' : ' ' . __($general->cur_text)); ?>

                            <?php if($data->capital_back == 1): ?>
                                + <span class="badge badge--success"><?php echo app('translator')->get('Capital'); ?></span>
                            <?php endif; ?>
                        <?php else: ?>
                            <?php echo app('translator')->get('Lifetime Earning'); ?>
                        <?php endif; ?>
                    </li>
                    <?php if($data->compound_interest): ?>
                        <li>
                            <?php echo app('translator')->get('Compound interest available'); ?>
                        </li>
                    <?php endif; ?>
                    <?php if($data->hold_capital): ?>
                        <li>
                            <?php echo app('translator')->get('Hold capital & reinvest'); ?>
                        </li>
                    <?php endif; ?>
                </ul>
                <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#investModal" data-plan="<?php echo e($data); ?>" class="btn btn-primary btn-small mt-30 investModal"><?php echo app('translator')->get('Invest now'); ?></a>
            </div>
        </div><!-- pricing-item end -->
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<div class="modal fade" id="investModal">
    <div class="modal-dialog modal-lg modal-dialog-centered ">
        <div class="modal-content modal-content-bg">
            <div class="modal-header">
                <?php if(auth()->check()): ?>
                    <strong class="modal-title text-white" id="ModalLabel">
                        <?php echo app('translator')->get('Confirm to invest on'); ?> <span class="planName"></span>
                    </strong>
                <?php else: ?>
                    <strong class="modal-title text-white" id="ModalLabel">
                        <?php echo app('translator')->get('At first sign in your account'); ?>
                    </strong>
                <?php endif; ?>
                <button type="button" class="close" data-bs-dismiss="modal">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="<?php echo e(route('user.invest.submit')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="plan_id">
                <?php if(auth()->check()): ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <h6 class="text-center investAmountRange"></h6>
                            <p class="text-center mt-1 interestDetails"></p>
                            <p class="text-center interestValidity"></p>
                            <p class="text-center calculatedInterest"></p>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Pay Via'); ?></label>
                                    <select class="form--control" name="wallet_type" required>
                                        <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                        <?php if(auth()->user()->deposit_wallet > 0): ?>
                                            <option value="deposit_wallet"><?php echo app('translator')->get('Deposit Wallet - ' . $general->cur_sym . showAmount(auth()->user()->deposit_wallet)); ?></option>
                                        <?php endif; ?>
                                        <?php if(auth()->user()->interest_wallet > 0): ?>
                                            <option value="interest_wallet"><?php echo app('translator')->get('Interest Wallet -' . $general->cur_sym . showAmount(auth()->user()->interest_wallet)); ?></option>
                                        <?php endif; ?>
                                        <?php $__currentLoopData = $gatewayCurrency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($data->id); ?>" <?php if(old('wallet_type') == $data->method_code): echo 'selected'; endif; ?> data-gateway="<?php echo e($data); ?>"><?php echo e($data->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <code class="gateway-info rate-info d-none"><?php echo app('translator')->get('Rate'); ?>: 1 <?php echo e($general->cur_text); ?> = <span class="rate"></span> <span class="method_currency"></span></code>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Invest Amount'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" min="0" class="form-control" name="amount" required>
                                        <div class="input-group-text"><?php echo e($general->cur_text); ?></div>
                                    </div>
                                    <code class="gateway-info d-none"><?php echo app('translator')->get('Charge'); ?>: <span class="charge text--base"></span> <?php echo e($general->cur_text); ?>. <?php echo app('translator')->get('Total amount'); ?>: <span class="total text--base"></span> <?php echo e($general->cur_text); ?></code>
                                </div>
                            </div>
                            <div class="col-md-6 compoundInterest">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Compound Interest'); ?> (<?php echo app('translator')->get('optional'); ?>)</label>
                                    <div class="input-group">
                                        <input type="number" min="0" class="form-control" name="compound_interest">
                                        <div class="input-group-text"><?php echo app('translator')->get('Times'); ?></div>
                                    </div>
                                    <small class="fst-italic text--info"><i class="las la-info-circle"></i> <?php echo app('translator')->get('Your interest will add to the investment capital amount for a specific time that you\'re entering.'); ?></small>
                                </div>
                            </div>
                            <?php if($general->schedule_invest): ?>
                                <div class="col-md-6 investTime">
                                    <div class="form-group">
                                        <label><?php echo app('translator')->get('Auto Schedule Invest'); ?></label>
                                        <select class="form--control" name="invest_time" required>
                                            <option value="invest_now"><?php echo app('translator')->get('Invest Now'); ?></option>
                                            <option value="schedule"><?php echo app('translator')->get('Schedule'); ?></option>
                                        </select>
                                        <small class="fst-italic text--info"><i class="las la-info-circle"></i> <?php echo app('translator')->get('You can set your investment as a scheduler or invest instant.'); ?></small>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>

                        <?php if($general->schedule_invest): ?>
                            <div class="row schedule">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="required"><?php echo app('translator')->get('Schedule For'); ?></label>
                                        <div class="input-group">
                                            <input type="number" min="0" class="form-control" name="schedule_times">
                                            <span class="input-group-text"><?php echo app('translator')->get('Times'); ?></span>
                                        </div>
                                        <small class="fst-italic text--info"><i class="las la-info-circle"></i> <?php echo app('translator')->get('Set how many times you want to invest.'); ?></small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="required"><?php echo app('translator')->get('After'); ?></label>
                                        <div class="input-group">
                                            <input type="number" min="0" class="form-control" name="hours">
                                            <span class="input-group-text"><?php echo app('translator')->get('Hours'); ?></span>
                                        </div>
                                        <small class="fst-italic text--info"><i class="las la-info-circle"></i> <?php echo app('translator')->get('Set a frequency at which you prefer to make investments.'); ?></small>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                <?php endif; ?>
                <div class="modal-footer">
                    <?php if(auth()->check()): ?>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                        <button type="submit" class="btn btn--base text--success"><?php echo app('translator')->get('Yes'); ?></button>
                    <?php else: ?>
                        <a href="<?php echo e(route('user.login')); ?>" class="btn btn--base w-100"><?php echo app('translator')->get('At first sign in your account'); ?></a>
                    <?php endif; ?>
                </div>
            </form>
        </div>
    </div>
</div>


<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict"
            var symbol = '<?php echo e($general->cur_sym); ?>';
            var currency = '<?php echo e($general->cur_text); ?>';
            var plan;

            $('.investModal').click(function() {
                $('.gateway-info').addClass('d-none');
                var modal = $('#investModal');
                plan = $(this).data('plan');
                modal.find('[name=plan_id]').val(plan.id);
                modal.find('.planName').text(plan.name);
                let fixedAmount = parseFloat(plan.fixed_amount).toFixed(2);
                let minimumAmount = parseFloat(plan.minimum).toFixed(2);
                let maximumAmount = parseFloat(plan.maximum).toFixed(2);
                let interestAmount = parseFloat(plan.interest);

                if (plan.fixed_amount > 0) {
                    modal.find('.investAmountRange').text(`Invest: ${symbol}${fixedAmount}`);
                    modal.find('[name=amount]').val(parseFloat(plan.fixed_amount).toFixed(2));
                    modal.find('[name=amount]').attr('readonly', true);
                } else {
                    modal.find('.investAmountRange').text(`Invest: ${symbol}${minimumAmount} - ${symbol}${maximumAmount}`);
                    modal.find('[name=amount]').val('');
                    modal.find('[name=amount]').removeAttr('readonly');
                }

                if (plan.interest_type == '1') {
                    modal.find('.interestDetails').html(`<strong> Interest: ${interestAmount}% </strong>`);
                } else {
                    modal.find('.interestDetails').html(`<strong> Interest: ${interestAmount} ${currency}  </strong>`);
                }
                if (plan.lifetime == '0') {
                    modal.find('.interestValidity').html(`<strong>  Per ${plan.time_setting.time} hours for  ${plan.repeat_time} times</strong>`);
                } else {
                    modal.find('.interestValidity').html(`<strong>  Per ${plan.time_setting.time} hours for life time </strong>`);
                }

                if (plan.compound_interest == '1') {
                    $('.compoundInterest').show();
                    $('.investTime').removeClass('col-md-12');
                } else {
                    $('.compoundInterest').hide();
                    $('.investTime').addClass('col-md-12');
                }
                calculateInterest();
            });

            $('[name=amount]').on('input', function() {
                $('[name=wallet_type]').trigger('change');
                calculateInterest();
            })

            $('[name=wallet_type]').change(function() {
                var amount = $('[name=amount]').val();
                if ($(this).val() && $(this).val() != 'deposit_wallet' && $(this).val() != 'interest_wallet' && amount) {
                    var resource = $('select[name=wallet_type] option:selected').data('gateway');
                    var fixed_charge = parseFloat(resource.fixed_charge);
                    var percent_charge = parseFloat(resource.percent_charge);
                    var charge = parseFloat(fixed_charge + (amount * percent_charge / 100)).toFixed(2);
                    $('.charge').text(charge);
                    $('.rate').text(parseFloat(resource.rate));
                    $('.gateway-info').removeClass('d-none');
                    if (resource.currency == '<?php echo e($general->cur_text); ?>') {
                        $('.rate-info').addClass('d-none');
                    } else {
                        $('.rate-info').removeClass('d-none');
                    }
                    $('.method_currency').text(resource.currency);
                    $('.total').text(parseFloat(charge) + parseFloat(amount));
                } else {
                    $('.gateway-info').addClass('d-none');
                }
            });

            $('[name=invest_time]').on('change', function() {
                let investTime = $(this).find(':selected').val();
                if (investTime == 'invest_now') {
                    $('.schedule').hide();
                } else {
                    $('.schedule').show();
                }
            }).change();

            $('[name=schedule_times]').on('input', function() {
                let text = $(this).val() == 1 ? `<?php echo app('translator')->get('After'); ?>` : `<?php echo app('translator')->get('Every'); ?>`;
                $('[name=hours]').closest('.form-group').find('label').text(text);
            });

            $('[name=compound_interest]').on('input', function() {
                calculateInterest();
            })

            function calculateInterest() {
                let interest = parseFloat(plan.interest);
                let interestType = plan.interest_type; //1: percent, 0: fixed
                let repeatTime = plan.repeat_time;
                let capitalBack = plan.capital_back;
                let investAmount = $('[name=amount]').val() * 1;
                let compoundInterest = $('[name=compound_interest]').val() ?? 0;
                let calculatedInterest = 0;
                let baseInterest = 0;

                if (repeatTime == 0 || investAmount == 0) {
                    $('.calculatedInterest').hide();
                    return false;
                } else {
                    $('.calculatedInterest').show();
                }

                let totalInterest = interest * repeatTime;

                if (interestType == '1') {
                    if (compoundInterest > 0) {
                        let remainingRepeatTime = repeatTime - compoundInterest;
                        let interestRatio = 1 + interest / 100;
                        let compoundCapital = investAmount * Math.pow(interestRatio, compoundInterest);
                        totalInterest = (compoundCapital * interest / 100) * remainingRepeatTime;
                    } else {
                        totalInterest = interest * investAmount / 100 * repeatTime;
                    }
                }

                totalInterest = capitalBack ? totalInterest : totalInterest - investAmount;
                $('.calculatedInterest').text(`<?php echo app('translator')->get('Total Profit'); ?> ` + symbol + totalInterest.toFixed(2));
            }

            <?php if(!$general->schedule_invest): ?>
                $('.modal-dialog').removeClass('modal-lg');
                $('.modal-dialog').find('.col-md-6').addClass('col-md-12');
            <?php endif; ?>

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/top1/trustpay.56-0.top/core/resources/views/templates/neo_dark/partials/plan.blade.php ENDPATH**/ ?>