
<?php $__env->startSection('panel'); ?>
<div class="row">
    <div class="col-md-12 mb-30">
        <div class="card bl--5-primary">
            <div class="card-body">
                <p class="text--primary"><?php echo app('translator')->get('If you want to send signals using push notification by the firebase? Your system must be SSL certified'); ?></p>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        <div class="card">
            <form action="#" method="POST">
                <?php echo csrf_field(); ?>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="fw-bold"><?php echo app('translator')->get('API Key'); ?> </label>
                                <input type="text" class="form-control" placeholder="<?php echo app('translator')->get('API Key'); ?>" name="apiKey" value="<?php echo e(@$general->firebase_config->apiKey); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="fw-bold"><?php echo app('translator')->get('Auth Domain'); ?> </label>
                                <input type="text" class="form-control" placeholder="<?php echo app('translator')->get('Auth Domain'); ?>" name="authDomain" value="<?php echo e(@$general->firebase_config->authDomain); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="fw-bold"><?php echo app('translator')->get('Project Id'); ?> </label>
                                <input type="text" class="form-control" placeholder="<?php echo app('translator')->get('Project Id'); ?>" name="projectId" value="<?php echo e(@$general->firebase_config->projectId); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="fw-bold"><?php echo app('translator')->get('Storage Bucket'); ?> </label>
                                <input type="text" class="form-control" placeholder="<?php echo app('translator')->get('Storage Bucket'); ?>" name="storageBucket" value="<?php echo e(@$general->firebase_config->storageBucket); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="fw-bold"><?php echo app('translator')->get('Messaging Sender Id'); ?> </label>
                                <input type="text" class="form-control" placeholder="<?php echo app('translator')->get('Messaging Sender Id'); ?>" name="messagingSenderId" value="<?php echo e(@$general->firebase_config->messagingSenderId); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="fw-bold"><?php echo app('translator')->get('App Id'); ?> </label>
                                <input type="text" class="form-control" placeholder="<?php echo app('translator')->get('App Id'); ?>" name="appId" value="<?php echo e(@$general->firebase_config->appId); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="fw-bold"><?php echo app('translator')->get('Measurement Id'); ?> </label>
                                <input type="text" class="form-control" placeholder="<?php echo app('translator')->get('Measurement Id'); ?>" name="measurementId" value="<?php echo e(@$general->firebase_config->measurementId); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="fw-bold"><?php echo app('translator')->get('Server key'); ?> </label>
                                <input type="text" class="form-control" placeholder="<?php echo app('translator')->get('Server key'); ?>" name="serverKey" value="<?php echo e(@$general->firebase_config->serverKey); ?>" required>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn--primary w-100 h-45"><?php echo app('translator')->get('Submit'); ?></button>
                </div>
            </form>
        </div><!-- card end -->
    </div>
</div>

<div id="pushNotifyModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Firebase Setup'); ?></h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="steps-tab" data-bs-toggle="tab" data-bs-target="#steps" type="button" role="tab" aria-controls="steps" aria-selected="true"><?php echo app('translator')->get('Steps'); ?></button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="configs-tab" data-bs-toggle="tab" data-bs-target="#configs" type="button" role="tab" aria-controls="configs" aria-selected="false"><?php echo app('translator')->get('Configs'); ?></button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="server-tab" data-bs-toggle="tab" data-bs-target="#server" type="button" role="tab" aria-controls="server" aria-selected="false"><?php echo app('translator')->get('Server Key'); ?></button>
                    </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade show active" id="steps" role="tabpanel" aria-labelledby="steps-tab">
                        <div class="table-responsive overflow-hidden">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('To Do'); ?></th>
                                        <th><?php echo app('translator')->get('Description'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    <td><?php echo app('translator')->get('Step 1'); ?></td>
                                    <td><?php echo app('translator')->get('Go to your Firebase account and select'); ?> <span class="text--primary">"<?php echo app('translator')->get('Go to console'); ?></span>" <?php echo app('translator')->get('in the upper-right corner of the page.'); ?></td>
                                </tr>
                                <tr>
                                    <td><?php echo app('translator')->get('Step 2'); ?></td>
                                    <td>
                                        <?php echo app('translator')->get('Select Add project and do the following to create your project.'); ?>
                                        <br>
                                        <code class="text--primary">
                                            <?php echo app('translator')->get('Use the name, Enable Google Analytics, Choose a name and the country for Google Analytics, Use the default analytics settings'); ?>
                                        </code>
                                    </td>
                                </tr>
                                <tr>
                                    <td><?php echo app('translator')->get('Step 3'); ?></td>
                                    <td><?php echo app('translator')->get('Within your Firebase project, select the gear next to Project Overview and choose Project settings.'); ?></td>
                                </tr>
                                <tr>
                                    <td><?php echo app('translator')->get('Step 4'); ?></td>
                                    <td><?php echo app('translator')->get('Next, set up a web app under the General section of your project settings.'); ?></td>
                                </tr>
                                <tr>
                                    <td><?php echo app('translator')->get('Step 5'); ?></td>
                                    <td><?php echo app('translator')->get('Next, go to Cloud Messaging in your Firebase project settings and enable Cloud Messaging API.'); ?></td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade mt-3 ms-2 text-center" id="configs" role="tabpanel" aria-labelledby="configs-tab">
                        <img src="<?php echo e(getImage('assets/images/firebase/' .'configs.png')); ?>">
                    </div>
                    <div class="tab-pane fade mt-3 ms-2 text-center" id="server" role="tabpanel" aria-labelledby="server-tab">
                        <img src="<?php echo e(getImage('assets/images/firebase/' .'server.png')); ?>">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn--dark" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <button type="button" data-bs-target="#pushNotifyModal" data-bs-toggle="modal" class="btn btn-outline--info">
        <i class="las la-question"></i><?php echo app('translator')->get('Help'); ?>
    </button>
    <button type="button" class="btn btn-outline--primary testPushNotify">
        <i class="las la-bell"></i><?php echo app('translator')->get('Test Notification'); ?>
    </button>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
    function pushNotifyAction(){

        if(!Notification){
            return notify('info', 'Push notifications not available in your browser. Try Chromium.');
        }

        if(Notification.permission === 'denied'){
            notify('info', 'Please allow / reset browser notification');
        }

        if (Notification.permission !== 'granted'){
            Notification.requestPermission();
        }else{
            var notification = new Notification('<?php echo e($general->site_name); ?>', {
                icon: "<?php echo e(getImage(getFilePath('logoIcon') .'/logo.png')); ?>",
                body: 'Push notification for testing purpose',
                vibrate: [200, 100, 200]
            });
            notification.onclick = function () {
                window.open("<?php echo e(route('admin.dashboard')); ?>");
            };
        }
    }

    $('.testPushNotify').on('click', function(){
        pushNotifyAction();
    });

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/crypto36/public_html/core/resources/views/admin/notification/push_setting.blade.php ENDPATH**/ ?>