<?php if($general->user_ranking): ?>
    <?php
        $userRanking = getContent('ranking.content', true);
        $userRankings = App\Models\UserRanking::active()->get();
    ?>

    <?php if($userRankings->count()): ?>
        <section class="referral-level-section border-top-1 pt-120 pb-120">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-6">
                        <div class="section-header text-center">
                            <h2 class="section__title"><?php echo e(__(@$userRanking->data_values->heading)); ?></h2>
                            <p><?php echo e(__(@$userRanking->data_values->sub_heading)); ?></p>
                        </div>
                    </div>
                </div>
                <div class="referral__level__area">
                    <?php
                        $firstPercent = 20;
                        $lastPercent = 100;
                        $perItem = ($lastPercent - $firstPercent) / ($userRankings->count() > 1 ? $userRankings->count() - 1 : $userRankings->count());
                    ?>

                    <?php $__currentLoopData = $userRankings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="referral__level__item">
                            <div class="referral__level__item__inner">
                                <div class="referral__left">
                                    <div class="referral__level__thumb">
                                        <img src="<?php echo e(getImage(getFilePath('userRanking') . '/' . $rank->icon, getFileSize('userRanking'))); ?>" alt="referral">
                                    </div>
                                    <div class="referral__level__name">
                                        <?php echo e(__($rank->name)); ?>

                                    </div>
                                </div>
                                <div class="referral__right">
                                    <div class="referral__level__content custom-width"data-custom_width="<?php echo e($perItem * $loop->index + $firstPercent); ?>">
                                        <div class="referral__level__content__content">
                                            <span><i class="las la-coins"></i> <?php echo app('translator')->get('Bonus'); ?>: <?php echo e($general->cur_sym); ?><?php echo e(showAmount($rank->bonus)); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="referral__tooltip">
                                <ul>
                                    <li class="d-flex justify-content-between">
                                        <?php echo app('translator')->get('Level'); ?>
                                        <span><?php echo e(__($rank->level)); ?></span>
                                    </li>
                                    <li class="d-flex justify-content-between">
                                        <?php echo app('translator')->get('Minimum Invest'); ?>
                                        <span><?php echo e($general->cur_sym); ?><?php echo e(showAmount($rank->minimum_invest)); ?></span>
                                    </li>
                                    <li class="d-flex justify-content-between">
                                        <?php echo app('translator')->get('Team Invest'); ?>
                                        <span><?php echo e($general->cur_sym); ?><?php echo e(showAmount($rank->min_referral_invest)); ?></span>
                                    </li>
                                    <li class="d-flex justify-content-between">
                                        <?php echo app('translator')->get('No. of Direct Referral'); ?>
                                        <span><?php echo e($rank->min_referral); ?></span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
    <?php endif; ?>
<?php endif; ?>

<?php if($general->user_ranking): ?>
    <?php $__env->startPush('script'); ?>
        <script>
            (function($) {
                "use strict";
                $('.custom-width').each(function(index, value) {
                    $(value).css("max-width", `${$(value).data('custom_width')}%`);
                });
            })(jQuery);
        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php /**PATH /home/xam/phemex.xa-m.pro/core/resources/views/templates/neo_dark/sections/ranking.blade.php ENDPATH**/ ?>