<?php $__env->startSection('panel'); ?>


<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--md  table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th scope="col"><?php echo app('translator')->get('SL'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Date'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $holidays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $holiday): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($holiday->date); ?></td>
                                    <td>
                                        <button
                                            data-action="<?php echo e(route('admin.setting.remove', $holiday->id)); ?>"
                                            class="btn btn-sm btn-outline--danger removeBtn"><i
                                                class="las la-trash"></i> <?php echo app('translator')->get('Delete'); ?></button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo app('translator')->get('Data not found'); ?></td>
                                </tr>
                            <?php endif; ?>

                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            <?php if($holidays->hasPages()): ?>
                <div class="card-footer py-4">
                    <?php echo e(paginateLinks($holidays)); ?>

                </div>
            <?php endif; ?>
        </div><!-- card end -->
    </div>
</div>

<div class="card mt-5">
    <div class="card-header"><b class="lead"><?php echo app('translator')->get('Weekly Holidays'); ?></b></div>
    <form action="<?php echo e(route('admin.setting.offday')); ?>" method="post">
        <?php echo csrf_field(); ?>
        <div class="card-body">
            <div class="row">
                <div class="form-group col-lg-3 col-sm-6 col-md-4">
                    <label class="form-control-label"> <?php echo app('translator')->get('Sunday'); ?></label>
                    <input type="checkbox" data-height="50" data-width="100%" data-size="large" data-onstyle="-success"
                        data-offstyle="-danger" data-bs-toggle="toggle" data-on="<?php echo app('translator')->get('Holiday'); ?>"
                        data-off="<?php echo app('translator')->get('Payday'); ?>" name="off_day[sun]" <?php if(@$general->off_day->sun): ?> checked <?php endif; ?>>
                </div>
                <div class="form-group col-lg-3 col-sm-6 col-md-4">
                    <label class="form-control-label"> <?php echo app('translator')->get('Monday'); ?></label>
                    <input type="checkbox" data-height="50" data-width="100%" data-size="large" data-onstyle="-success"
                        data-offstyle="-danger" data-bs-toggle="toggle" data-on="<?php echo app('translator')->get('Holiday'); ?>"
                        data-off="<?php echo app('translator')->get('Payday'); ?>" name="off_day[mon]" <?php if(@$general->off_day->mon): ?> checked <?php endif; ?>>
                </div>
                <div class="form-group col-lg-3 col-sm-6 col-md-4">
                    <label class="form-control-label"> <?php echo app('translator')->get('Tuesday'); ?></label>
                    <input type="checkbox" data-height="50" data-width="100%" data-size="large" data-onstyle="-success"
                        data-offstyle="-danger" data-bs-toggle="toggle" data-on="<?php echo app('translator')->get('Holiday'); ?>"
                        data-off="<?php echo app('translator')->get('Payday'); ?>" name="off_day[tue]" <?php if(@$general->off_day->tue): ?> checked <?php endif; ?>>
                </div>
                <div class="form-group col-lg-3 col-sm-6 col-md-4">
                    <label class="form-control-label"> <?php echo app('translator')->get('Wednesday'); ?></label>
                    <input type="checkbox" data-height="50" data-width="100%" data-size="large" data-onstyle="-success"
                        data-offstyle="-danger" data-bs-toggle="toggle" data-on="<?php echo app('translator')->get('Holiday'); ?>"
                        data-off="<?php echo app('translator')->get('Payday'); ?>" name="off_day[wed]" <?php if(@$general->off_day->wed): ?> checked <?php endif; ?>>
                </div>
                <div class="form-group col-lg-3 col-sm-6 col-md-4">
                    <label class="form-control-label"> <?php echo app('translator')->get('Thursday'); ?></label>
                    <input type="checkbox" data-height="50" data-width="100%" data-size="large" data-onstyle="-success"
                        data-offstyle="-danger" data-bs-toggle="toggle" data-on="<?php echo app('translator')->get('Holiday'); ?>"
                        data-off="<?php echo app('translator')->get('Payday'); ?>" name="off_day[thu]" <?php if(@$general->off_day->thu): ?> checked <?php endif; ?>>
                </div>
                <div class="form-group col-lg-3 col-sm-6 col-md-4">
                    <label class="form-control-label"> <?php echo app('translator')->get('Friday'); ?></label>
                    <input type="checkbox" data-height="50" data-width="100%" data-size="large" data-onstyle="-success"
                        data-offstyle="-danger" data-bs-toggle="toggle" data-on="<?php echo app('translator')->get('Holiday'); ?>"
                        data-off="<?php echo app('translator')->get('Payday'); ?>" name="off_day[fri]" <?php if(@$general->off_day->fri): ?> checked <?php endif; ?>>
                </div>
                <div class="form-group col-lg-3 col-sm-6 col-md-4">
                    <label class="form-control-label"> <?php echo app('translator')->get('Saturday'); ?></label>
                    <input type="checkbox" data-height="50" data-width="100%" data-size="large" data-onstyle="-success"
                        data-offstyle="-danger" data-bs-toggle="toggle" data-on="<?php echo app('translator')->get('Holiday'); ?>"
                        data-off="<?php echo app('translator')->get('Payday'); ?>" name="off_day[sat]" <?php if(@$general->off_day->sat): ?> checked <?php endif; ?>>
                </div>
                <div class="form-group mb-0">
                    <button type="submit" class="btn btn--primary w-100 h-45"><?php echo app('translator')->get('Submit'); ?></button>
                </div>
            </div>
        </div>
    </form>
</div>


<div class="modal fade" id="addHoliday">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Add Holiday'); ?></h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="<?php echo e(route('admin.setting.holiday.submit')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group">
                        <label><?php echo app('translator')->get('Title'); ?></label>
                        <input type="text" class="form-control" name="title" required>
                    </div>
                    <div class="form-group">
                        <label><?php echo app('translator')->get('Enter Date'); ?></label>
                        <input type="date" class="form-control" name="date" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary w-100 h-45"><?php echo app('translator')->get('Submit'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="removeModal">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="removeModalLabel"><?php echo app('translator')->get('Remove Holiday'); ?></h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="las la-times"></i></span>
                </button>
            </div>
            <form action="" method="post">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <p><?php echo app('translator')->get('Are you sure to remove this holiday?'); ?></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--dark" data-bs-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                    <button type="submit" class="btn btn--primary"><?php echo app('translator')->get('Yes'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('breadcrumb-plugins'); ?>
    <button class="btn btn-outline--primary btn-sm" data-bs-toggle="modal" data-bs-target="#addHoliday"><i
            class="las la-plus"></i> <?php echo app('translator')->get('Add New'); ?></button>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        (function ($) {
            "use strict";
            $('.removeBtn').on('click', function () {
                var modal = $('#removeModal');
                modal.find('form').attr('action', $(this).data('action'));
                modal.modal('show');
            });
        })(jQuery);

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/crypto36/public_html/core/resources/views/admin/setting/holidays.blade.php ENDPATH**/ ?>