<?php
    $subscribeContent = getContent('subscribe.content',true);
?>

<section class="newsletter-section  pt-150  pb-150 " id="subscribe">
    <div class="container">
        <div class="row justify-content-center text-center">
            <div class="col-lg-7">
                <div class="section-header margin-olpo">
                    <h2 class="section__title"><?php echo e(__(@$subscribeContent->data_values->heading)); ?></h2>
                    <p><?php echo e(__(@$subscribeContent->data_values->sub_heading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            <div class="col-md-7">
                <form class="newslater-form" method="post">
                    <?php echo csrf_field(); ?>
                    <input type="email" name="email" placeholder="<?php echo app('translator')->get('Email Address'); ?>">
                    <button type="submit">
                        <i class="fa fa-paper-plane"></i>
                    </button>
                </form>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('script'); ?>
<script>
    (function ($) {
        "use strict";
        $('.newslater-form').on('submit', function (e) {
            e.preventDefault();
            var data = $('.newslater-form').serialize();
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('subscribe')); ?>",
                data: data,
                success: function (response) {
                        if(response.status == 'success'){
                            notify('success', response.message);
                            $('#email').val('');
                        }else{
                            notify('error', response.message);
                        }
                }
           });
        });
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php /**PATH /home/bmsskabi/public_html/core/resources/views/templates/neo_dark/sections/subscribe.blade.php ENDPATH**/ ?>