<?php
    $topInvestor = \App\Models\Invest::with('user')
        ->selectRaw('SUM(amount) as totalAmount, user_id')
        ->orderBy('totalAmount', 'desc')
        ->groupBy('user_id')
        ->limit(8)
        ->get();
    
    $top_investorContent = getContent('top_investor.content', true);
?>

<!-- investor-section start -->
<section class="investor-section pb-150 pt-150">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="section-header text-center">
                    <h2 class="section__title"><?php echo e(__(@$top_investorContent->data_values->heading)); ?></h2>
                    <p><?php echo e(__(@$top_investorContent->data_values->sub_heading)); ?></p>
                </div><!-- section-header end -->
            </div>
        </div>
        <div class="row gy-4 justify-content-center">
            <?php $__currentLoopData = $topInvestor; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-3 col-lg-4 col-md-6">
                    <div class="investor-item">
                        <span class="investor-item__number"><?php echo e(ordinal($loop->iteration)); ?></span>
                        <div class="investor-item__content">
                            <h6 class="investor__name text-shadow"><?php echo e(@json_decode(json_encode($data->user->username))); ?></h3>
                                <p><?php echo app('translator')->get('Total Invest'); ?> <span class="amount"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($data->totalAmount)); ?></span></p>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<!-- investor-section end -->
<?php /**PATH /home/xam/kibobikeai.xa-m.pro/core/resources/views/templates/neo_dark/sections/top_investor.blade.php ENDPATH**/ ?>