<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
date_default_timezone_set('Asia/Kolkata');

$servername = "localhost";
$username   = "crypto36_crypto36";
$password   = "crypto36_crypto36";
$dbname     = "crypto36_crypto36";

// === Configuration ===
$accessKey = "qes9c2d0iEa2r2XO8Wujlg";
$accessSecretBase64 = "eGdHQ2x3Zkl1VU9tMGhmMGVlYkxMUQ==";  // Base64 encoded secret
$method = "POST";
$apiUrl = "https://api.coolamgg.com/api/v2/create"; // Full URL
$requestPath = "/api/v2/create"; // must match exactly
$callbackUrl = "https://api.crypto365.live//pay/notify/notify.php";

// === Generate Signature ===
$timestamp = time();
$nonce = rand(10000000, 99999999);
$accessSecret = base64_decode($accessSecretBase64);

$signString = "$method&$requestPath&$accessKey&$timestamp&$nonce&$accessSecret";
$sign = md5($signString);

// === Get input ===
$phone  = isset($_GET['phone']) ? $_GET['phone'] : '';
$amount = isset($_GET['amount']) ? (float)$_GET['amount'] : 0.0;

if (empty($phone) || $amount <= 0) {
    die("Invalid input: Please provide a valid phone number and amount.");
}

// === Connect to DB ===
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

$stmt = $conn->prepare("SELECT id FROM users WHERE username = ?");
if ($stmt === false) {
    die("Database prepare failed: " . $conn->error);
}

$stmt->bind_param("s", $phone);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

if (!$user) {
    $conn->close();
    die("User not found. Please ensure the phone number is correct.");
}
$userId = $user['id'];
$conn->close();

// === Payment Data ===
$merchantOrderNo = 'CRYPTO365' . str_pad(mt_rand(0, 999999999999999), 15, '0', STR_PAD_LEFT);
$orderDate       = date('Y-m-d H:i:s');

// === Payload ===
$payload = [
    "McorderNo"   => $merchantOrderNo,
    "Amount"      => $amount,
    "Type"        => "inr",
    "ChannelCode" => "71001",
    "CallBackUrl" => $callbackUrl,
    "JumpUrl"     => $callbackUrl
];

// === Headers ===
$headers = [
    "Content-Type: application/json",
    "accessKey: $accessKey",
    "timestamp: $timestamp",
    "nonce: $nonce",
    "sign: $sign"
];

// === Send API Request ===
$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

$response = curl_exec($ch);
if (curl_errno($ch)) {
    file_put_contents("logdata.txt", "CURL Error at " . date('Y-m-d H:i:s') . ": " . curl_error($ch) . "\n\n", FILE_APPEND);
    die('Curl error: ' . curl_error($ch));
}
curl_close($ch);

// === Log API Response ===
file_put_contents("logdata.txt", "API Response at " . date('Y-m-d H:i:s') . ":\n" . $response . "\n\n", FILE_APPEND);

// === Parse API Response ===
$responseData = json_decode($response, true);
if ($responseData === null) {
    file_put_contents("logdata.txt", "Failed to decode API response at " . date('Y-m-d H:i:s') . "\n\n", FILE_APPEND);
    die("Error: Failed to decode API response. Response was: " . $response);
}

$respCode = isset($responseData['type']) ? $responseData['type'] : 'FAIL';
$tradeMsg = isset($responseData['message']) ? $responseData['message'] : 'Unknown error';

if ($respCode == 'success') {
    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        file_put_contents("logdata.txt", "DB Connection Failed at " . date('Y-m-d H:i:s') . ": " . $conn->connect_error . "\n\n", FILE_APPEND);
        die("Database connection failed: " . $conn->connect_error);
    }

    $plan_id         = 0;
    $method_code     = 1000;
    $charge          = 0.00;
    $method_currency = 'INR';
    $rate            = 1.00;
    $final_amo       = $amount + $charge;
    $detail          = 'Payment initiated. Gateway response: ' . json_encode($responseData);
    $status          = 2;
    $payment_try     = 1;
    $from_api        = 1;
    $currentTime     = date('Y-m-d H:i:s');
    $payUrl          = $payUrl = isset($responseData['result']['payUrl']) ? $responseData['result']['payUrl'] : '';

    $sql = "INSERT INTO deposits (user_id, plan_id, method_code, amount, method_currency, charge, rate, final_amo, detail, trx, status, payment_try, from_api, created_at, updated_at)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        file_put_contents("logdata.txt", "DB Prepare Failed at " . date('Y-m-d H:i:s') . ": " . $conn->error . "\n\n", FILE_APPEND);
        die("Database prepare failed: " . $conn->error);
    }

    $stmt->bind_param("iiidssddssiiiss", $userId, $plan_id, $method_code, $amount, $method_currency, $charge, $rate, $final_amo, $detail, $merchantOrderNo, $status, $payment_try, $from_api, $currentTime, $currentTime);

    if ($stmt->execute()) {
        file_put_contents("logdata.txt", "DB Insert Success at " . date('Y-m-d H:i:s') . " for Order: $merchantOrderNo\n\n", FILE_APPEND);
        if (!empty($payUrl)) {
            header("Location: " . $payUrl);
            exit;
        } else {
            echo "Payment page URL missing, but transaction was logged.";
        }
    } else {
        file_put_contents("logdata.txt", "DB Insert Failed at " . date('Y-m-d H:i:s') . " for Order: $merchantOrderNo | Error: " . $stmt->error . "\n\n", FILE_APPEND);
        echo "A critical error occurred. Please contact support and provide this reference: " . $merchantOrderNo;
    }

    $stmt->close();
    $conn->close();

} else {
    file_put_contents("logdata.txt", "Payment Failed at " . date('Y-m-d H:i:s') . ": $tradeMsg\n\n", FILE_APPEND);
    echo "Payment request failed: " . htmlspecialchars($tradeMsg);
}
?>
