<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

function generateReferralTrxId() {
    $prefix = 'REF';
    $randomDigits = str_pad(mt_rand(0, 9999999), 7, '0', STR_PAD_LEFT);
    return $prefix . $randomDigits;
}

$secretKey = "c9f0f9cd7ada4d6384c920131d107087";
$data = $_POST;

$requiredFields = [
    "tradeResult", "mchId", "mchOrderNo", "oriAmount", "amount", "orderDate",
    "orderNo", "signType", "sign"
];

foreach ($requiredFields as $field) {
    if (!isset($data[$field])) {
        error_log("Callback error: Missing field '{$field}'");
        echo "fail";
        exit;
    }
}

$tradeResult = $data['tradeResult'];
$mchId       = $data['mchId'];
$mchOrderNo  = $data['mchOrderNo'];
$oriAmount   = $data['oriAmount'];
$amount      = (float)$data['amount'];
$orderDate   = $data['orderDate'];
$orderNo     = $data['orderNo'];
$signType    = $data['signType'];
$sign        = $data['sign'];
$merRetMsg   = isset($data['merRetMsg']) ? $data['merRetMsg'] : "";

$servername = "localhost";
$dbname = "crypto36_crypto36";
$username = "crypto36_crypto36";
$password = "crypto36_crypto36";

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    error_log("Connection failed: " . $conn->connect_error);
    echo "fail";
    exit;
}

// 1. Check if deposit exists
$stmt = $conn->prepare("SELECT status, user_id FROM deposits WHERE trx = ?");
$stmt->bind_param('s', $mchOrderNo);
$stmt->execute();
$stmt->bind_result($status, $userID);

if ($stmt->fetch()) {
    if ((int)$status === 1) {
        echo "success";
        $stmt->close();
        $conn->close();
        exit;
    }
} else {
    echo "success"; // deposit not found, assume processed already
    $stmt->close();
    $conn->close();
    exit;
}
$stmt->close();

// 2. Get user by ID
$stmt = $conn->prepare("SELECT id, username, ref_by FROM users WHERE id = ?");
$stmt->bind_param('i', $userID);
$stmt->execute();
$stmt->bind_result($userIdFetched, $username, $refBy);
if (!$stmt->fetch()) {
    error_log("Callback error: User not found for user_id '{$userID}' with order '{$mchOrderNo}'");
    echo "fail";
    $stmt->close();
    $conn->close();
    exit;
}
$stmt->close();

// 3. Process successful payment
if ($tradeResult === "1") {
    // Update deposit status
    $stmt = $conn->prepare("UPDATE deposits SET status = 1, btc_wallet = ? WHERE trx = ?");
    $stmt->bind_param('ss', $sign, $mchOrderNo);
    $stmt->execute();
    $stmt->close();

    // Update user's deposit_wallet
    $stmt = $conn->prepare("UPDATE users SET deposit_wallet = deposit_wallet + ? WHERE username = ?");
    $stmt->bind_param('ds', $amount, $username);
    $stmt->execute();
    $stmt->close();

    // ---- Referral Commission Logic ----
    if ($refBy) {
        // Get referrer info
        $stmt = $conn->prepare("SELECT id, interest_wallet FROM users WHERE id = ?");
        $stmt->bind_param('i', $refBy);
        $stmt->execute();
        $stmt->bind_result($referrerId, $interestWallet);
        if ($stmt->fetch()) {
            $commissionRate = 18;
            $commissionAmount = ($amount * $commissionRate) / 100;
            $newInterestWallet = $interestWallet + $commissionAmount;
        }
        $stmt->close();

        // Update referrer's interest wallet
        $stmt = $conn->prepare("UPDATE users SET interest_wallet = ? WHERE id = ?");
        $stmt->bind_param('di', $newInterestWallet, $referrerId);
        $stmt->execute();
        $stmt->close();

        // Log commission transaction
        $trxId = generateReferralTrxId();
        $details = 'Referral commission from user ID ' . $userID;
        $walletType = 'interest_wallet';
        $remark = 'referral_commission';
        $charge = 0;
        $trxType = '+';

        $stmt = $conn->prepare("
            INSERT INTO transactions (
                user_id, amount, post_balance, charge, trx_type, details, trx, wallet_type, remark, created_at
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())
        ");
        $stmt->bind_param(
            'iddssssss',
            $referrerId, $commissionAmount, $newInterestWallet, $charge,
            $trxType, $details, $trxId, $walletType, $remark
        );
        $stmt->execute();
        $stmt->close();
    }

    echo "success";

// 4. Handle failed payment
} elseif ($tradeResult === "2") {
    $stmt = $conn->prepare("UPDATE deposits SET status = 3, btc_wallet = ? WHERE trx = ?");
    $stmt->bind_param('ss', $sign, $mchOrderNo);
    $stmt->execute();
    $stmt->close();

    echo "success";

// 5. Unknown status
} else {
    error_log("Callback received for order '{$mchOrderNo}' with non-successful status: '{$tradeResult}'");
    echo "success";
}

$conn->close();
exit;
?>
