<?php
header('Content-Type: application/json; charset=utf-8');
header('Strict-Transport-Security: max-age=31536000');
header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
header('Access-Control-Allow-Credentials: true');
$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
header('Access-Control-Allow-Origin: ' . $origin);
header('vary: Origin');

date_default_timezone_set("Asia/Kolkata");
$shonubody = file_get_contents("php://input");
$payload = json_decode($shonubody, true);


$res = [
    "data" => [],
    "msgParameters" => null,
    "code" => 0,
    "msg" => "Succeed",
    "msgCode" => 0
];

if (!isset($payload['formId'])) {
    $res['data'] = [
        'error' => 'formId not provided'
    ];
    $res['msg'] = 'formId not provided';
    $res['code'] = 400; 
} elseif ($payload['formId'] == 14) {
    $res['data'] = [
        'formFields' => [
            [
                'id' => 59,
                'workOrderFormConfigId' => 14,
                'sort' => 0,
                'fieldName' => 'Order Number',
                'typeCode' => 'DepositOrderNo',
                'isRequired' => 1
            ],
            [
                'id' => 2142,
                'workOrderFormConfigId' => 14,
                'sort' => 1,
                'fieldName' => 'Deposit not received video/PDF',
                'typeCode' => 'FileUpload',
                'isRequired' => 0
            ],
            [
                'id' => 58,
                'workOrderFormConfigId' => 14,
                'sort' => 2,
                'fieldName' => 'Receiver UPI ID',
                'typeCode' => 'TextContent',
                'isRequired' => 1
            ],
            [
                'id' => 57,
                'workOrderFormConfigId' => 14,
                'sort' => 3,
                'fieldName' => 'UTR number',
                'typeCode' => 'UTR',
                'isRequired' => 0
            ],
            [
                'id' => 60,
                'workOrderFormConfigId' => 14,
                'sort' => 4,
                'fieldName' => 'Deposit proof receipt detail',
                'typeCode' => 'ImageUpload',
                'isRequired' => 0
            ],
            [
                'id' => 85,
                'workOrderFormConfigId' => 14,
                'sort' => 5,
                'fieldName' => 'OrderAmount ',
                'typeCode' => 'OrderAmount',
                'isRequired' => 1
            ],
            [
                'id' => 4413,
                'workOrderFormConfigId' => 14,
                'sort' => 6,
                'fieldName' => 'PDF Password',
                'typeCode' => 'TextContent',
                'isRequired' => 0
            ]
        ],
        'hasUserGuide' => 1,
        'displayName' => 'Deposit Not Receive'
    ];
} elseif ($payload['formId'] == 16) {
    $res['data'] = [
        'formFields' => [
            [
                'id' => 63,
                'workOrderFormConfigId' => 16,
                'sort' => 0,
                'fieldName' => 'Correct IFSC Code',
                'typeCode' => 'IFSC',
                'isRequired' => 1
            ],
            [
                'id' => 64,
                'workOrderFormConfigId' => 16,
                'sort' => 0,
                'fieldName' => 'Bank number',
                'typeCode' => 'BankAccountNumber',
                'isRequired' => 1
            ]
        ],
        'hasUserGuide' => 1,
        'displayName' => 'IFSC Modification'
    ];
  } elseif ($payload['formId'] == 18) {
    $res['data'] = [
        'formFields' => [
            [
                'id' => 71,
                'workOrderFormConfigId' => 18,
                'sort' => 0,
                'fieldName' => 'Old Passbook Bank',
                'typeCode' => 'ImageUpload',
                'isRequired' => 1
            ],
            [
                'id' => 69,
                'workOrderFormConfigId' => 18,
                'sort' => 0,
                'fieldName' => 'Bank account',
                'typeCode' => 'BankAccountNumber',
                'isRequired' => 1
            ],
            [
                'id' => 68,
                'workOrderFormConfigId' => 18,
                'sort' => 0,
                'fieldName' => 'Selfie holding your ID card',
                'typeCode' => 'ImageUpload',
                'isRequired' => 1
            ],
            [
                'id' => 70,
                'workOrderFormConfigId' => 18,
                'sort' => 0,
                'fieldName' => 'Latest Deposit Receipt Proof',
                'typeCode' => 'ImageUpload',
                'isRequired' => 1
            ]
        ],
        'hasUserGuide' => 1,
        'displayName' => 'Delete Withdraw Bank Account and Rebind'
    ];
} elseif ($payload['formId'] == 30) {
    // If `formId` is 30, provide the form fields for "Self-service Delete Bank Account and Rebind"
    $res['data'] = [
        'formFields' => [
            [
                'id' => 131,
                'workOrderFormConfigId' => 30,
                'sort' => 0,
                'fieldName' => 'Register phone number to receive OTP',
                'typeCode' => 'PhoneEmailCaptcha',
                'isRequired' => 1
            ]
        ],
        'hasUserGuide' => 1,
        'displayName' => 'Self-service Delete Bank Account and Rebind'
    ];
} elseif ($payload['formId'] == 15) {
    $res['data'] = [
        'formFields' => [
            [
                'id' => 61,
                'workOrderFormConfigId' => 15,
                'sort' => 0,
                'fieldName' => 'Correct bank name',
                'typeCode' => 'CardName',
                'isRequired' => 1
            ],
            [
                'id' => 62,
                'workOrderFormConfigId' => 15,
                'sort' => 0,
                'fieldName' => 'Bank number',
                'typeCode' => 'BankAccountNumber',
                'isRequired' => 1
            ]
        ],
        'hasUserGuide' => 1,
        'displayName' => 'Change bank name'
    ];
} elseif ($payload['formId'] == 31) {
    $res['data'] = [
        'formFields' => [
            [
                'id' => 133,
                'workOrderFormConfigId' => 31,
                'sort' => 0,
                'fieldName' => 'Register phone number to receive OTP',
                'typeCode' => 'PhoneEmailCaptcha',
                'isRequired' => 1
            ]
        ],
        'hasUserGuide' => 1,
        'displayName' => 'Self-service to Delete Old USDT Address and Rebind'
    ];
 } elseif ($payload['formId'] == 17) {
    $res['data'] = [
        'formFields' => [
            [
                'id' => 65,
                'workOrderFormConfigId' => 17,
                'sort' => 0,
                'fieldName' => 'Photo Selfie Holding Identity Card',
                'typeCode' => 'ImageUpload',
                'isRequired' => 1
            ],
            [
                'id' => 66,
                'workOrderFormConfigId' => 17,
                'sort' => 0,
                'fieldName' => 'Photo Selfie Hold USDT Address',
                'typeCode' => 'ImageUpload',
                'isRequired' => 1
            ],
            [
                'id' => 67,
                'workOrderFormConfigId' => 17,
                'sort' => 0,
                'fieldName' => 'Deposit Receipt Proof',
                'typeCode' => 'ImageUpload',
                'isRequired' => 1
            ]
        ],
        'hasUserGuide' => 1,
        'displayName' => 'Delete Old USDT Address and Rebind'
    ];
  } elseif ($payload['formId'] == 75) {
    $res['data'] = [
        'formFields' => [
            [
                'id' => 391,
                'workOrderFormConfigId' => 75,
                'sort' => 0,
                'fieldName' => 'Attach clear screenshot photo/video of the problem (optional)',
                'typeCode' => 'FileUpload',
                'isRequired' => 0
            ],
            [
                'id' => 390,
                'workOrderFormConfigId' => 75,
                'sort' => 0,
                'fieldName' => 'Explain the issue happen to you inside the game clear and detail',
                'typeCode' => 'LongText',
                'isRequired' => 1
            ]
        ],
        'hasUserGuide' => 0,
        'displayName' => 'Game Problems'
    ];
  } elseif ($payload['formId'] == 883) {
    $res['data'] = [
        'formFields' => [
        [
            'id' => 690,
            'workOrderFormConfigId' => 883,
            'sort' => 0,
            'fieldName' => 'BDGWin ID',
            'typeCode' => 'UserId',
            'isRequired' => 1
        ]
    ],
    'hasUserGuide' => 0,
    'displayName' => 'Aviator Lucky Bonus'
    ];
  } elseif ($payload['formId'] == 884) {
    $res['data'] = [
        'formFields' => [
        [
            'id' => 3628,
            'workOrderFormConfigId' => 884,
            'sort' => 0,
            'fieldName' => 'Consecutive Win Streak',
            'typeCode' => 'TextContent',
            'isRequired' => 1
        ],
        [
            'id' => 3626,
            'workOrderFormConfigId' => 884,
            'sort' => 1,
            'fieldName' => 'Start of winning period',
            'typeCode' => 'TextContent',
            'isRequired' => 1
        ],
        [
            'id' => 3883,
            'workOrderFormConfigId' => 884,
            'sort' => 2,
            'fieldName' => 'End of winning period',
            'typeCode' => 'TextContent',
            'isRequired' => 1
        ]
    ],
    'hasUserGuide' => 0,
    'displayName' => 'Wingo 1 Min Win Streak Bonus'
    ];
  } elseif ($payload['formId'] == 25) {
    $res['data'] = [
        'formFields' => [
            [
                'id' => 3638,
                'workOrderFormConfigId' => 25,
                'sort' => 0,
                'fieldName' => 'More than 3 days not receive, attach PDF bank statement',
                'typeCode' => 'TextContent',
                'isRequired' => 1
            ],
            [
                'id' => 3637,
                'workOrderFormConfigId' => 25,
                'sort' => 1,
                'fieldName' => 'Provide Video Record login Bank Account showing Bank Detail with bank statement.',
                'typeCode' => 'FileUpload',
                'isRequired' => 1
            ],
            [
                'id' => 3636,
                'workOrderFormConfigId' => 25,
                'sort' => 2,
                'fieldName' => 'Withdrawal amount',
                'typeCode' => 'WithdrawAmount',
                'isRequired' => 1
            ],
            [
                'id' => 3635,
                'workOrderFormConfigId' => 25,
                'sort' => 3,
                'fieldName' => 'Withdraw Order number',
                'typeCode' => 'WithdrawOrderNo',
                'isRequired' => 1
            ]
        ],
        'hasUserGuide' => 1,
        'displayName' => 'Withdrawal problem'
    ];
  } elseif ($payload['formId'] == 890) {
    $res['data'] = [
        'formFields' => [
            [
                'id' => 3706,
                'workOrderFormConfigId' => 890,
                'sort' => 0,
                'fieldName' => 'Screenshot of BDGWin ID',
                'typeCode' => 'ImageUpload',
                'isRequired' => 1
            ],
            [
                'id' => 3708,
                'workOrderFormConfigId' => 890,
                'sort' => 1,
                'fieldName' => 'Photo of government card',
                'typeCode' => 'ImageUpload',
                'isRequired' => 1
            ],
            [
                'id' => 3705,
                'workOrderFormConfigId' => 890,
                'sort' => 2,
                'fieldName' => 'Photo Deposit Receipt Proof 1',
                'typeCode' => 'ImageUpload',
                'isRequired' => 1
            ],
            
            [
                'id' => 3703,
                'workOrderFormConfigId' => 890,
                'sort' => 4,
                'fieldName' => 'Photo of your own USDT address bind at BDGWin',
                'typeCode' => 'ImageUpload',
                'isRequired' => 1
            ],
            [
                'id' => 3710,
                'workOrderFormConfigId' => 890,
                'sort' => 5,
                'fieldName' => 'Name of crypto exchange platform',
                'typeCode' => 'TextContent',
                'isRequired' => 1
            ],
            [
                'id' => 3707,
                'workOrderFormConfigId' => 890,
                'sort' => 6,
                'fieldName' => 'Text type of wallet address',
                'typeCode' => 'TextContent',
                'isRequired' => 1
            ],
            [
                'id' => 3709,
                'workOrderFormConfigId' => 890,
                'sort' => 7,
                'fieldName' => 'Photo of your new USDT address',
                'typeCode' => 'ImageUpload',
                'isRequired' => 1
            ]
        ],
        'hasUserGuide' => 0,
        'displayName' => 'USDT verification (Non Indian Members)'
    ];
  } elseif ($payload['formId'] == 891) {
    $res['data'] = [
        'formFields' => [
            [
                'id' => 3713,
                'workOrderFormConfigId' => 891,
                'sort' => 0,
                'fieldName' => 'Screenshot of BDGWin ID',
                'typeCode' => 'ImageUpload',
                'isRequired' => 1
            ],
            [
                'id' => 3712,
                'workOrderFormConfigId' => 891,
                'sort' => 1,
                'fieldName' => 'Photo of Adhar Card',
                'typeCode' => 'ImageUpload',
                'isRequired' => 1
            ],
            [
                'id' => 3714,
                'workOrderFormConfigId' => 891,
                'sort' => 2,
                'fieldName' => 'Photo of Deposit Receipt Proof 1',
                'typeCode' => 'ImageUpload',
                'isRequired' => 1
            ],
            [
                'id' => 3715,
                'workOrderFormConfigId' => 891,
                'sort' => 4,
                'fieldName' => 'Photo of your own USDT address bind at BDGWin',
                'typeCode' => 'ImageUpload',
                'isRequired' => 1
            ],
            [
                'id' => 3711,
                'workOrderFormConfigId' => 891,
                'sort' => 5,
                'fieldName' => 'Name of crypto exchange platform',
                'typeCode' => 'TextContent',
                'isRequired' => 1
            ],
            [
                'id' => 3716,
                'workOrderFormConfigId' => 891,
                'sort' => 6,
                'fieldName' => 'Text type of wallet address',
                'typeCode' => 'TextContent',
                'isRequired' => 1
            ],
            [
                'id' => 3717,
                'workOrderFormConfigId' => 891,
                'sort' => 7,
                'fieldName' => 'Photo of your new USDT address',
                'typeCode' => 'ImageUpload',
                'isRequired' => 1
            ]
        ],
        'hasUserGuide' => 0,
        'displayName' => 'USDT verification (Indian Members)'
    ];

    
    $res['msgParameters'] = null;
    $res['code'] = 0;
    $res['msg'] = 'Succeed';
    $res['msgCode'] = 0;
} else {
    $res['data'] = [
        'error' => 'Invalid formId'
    ];
    $res['msg'] = 'Invalid formId';
    $res['code'] = 400;
}


http_response_code($res['code']);
echo json_encode($res, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
?>
