<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
date_default_timezone_set('Asia/Kolkata');

$servername = "localhost";
$username   = "crypto36_crypto36";
$password   = "crypto36_crypto36";
$dbname     = "crypto36_crypto36";

$apiKey      = "d9c774db82d94dcf827b2a8b0ecbc203";
$merchantId  = '991100578';

$notify_url = "https://crypto365.live/gwinyt/verify.php";
$page_url   = "https://crypto365.live/user/deposit/history";

function generateSign(array $params, $secretkey) {
    $filteredParams = array_filter($params, function($value) {
        return $value !== '' && !is_null($value);
    });
    ksort($filteredParams);
    $stringParts = [];
    foreach ($filteredParams as $key => $value) {
        if ($key == 'sign') continue;
        $stringParts[] = $key . '=' . $value;
    }
    $signStr = implode('&', $stringParts) . '&key=' . $secretkey;
    return md5($signStr);
}

$phone  = isset($_GET['phone']) ? $_GET['phone'] : '';
$amount = isset($_GET['amount']) ? (float)$_GET['amount'] : 0.0;

if (empty($phone) || $amount <= 0) {
    die("Invalid input: Please provide a valid phone number and amount.");
}

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

$stmt = $conn->prepare("SELECT id FROM users WHERE username = ?");
if ($stmt === false) {
    die("Database prepare failed: " . $conn->error);
}
$stmt->bind_param("s", $phone);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

if (!$user) {
    $conn->close();
    die("User not found. Please ensure the phone number is correct.");
}
$userId = $user['id'];
$conn->close();

$merchantOrderNo = 'CRYPTO365' . str_pad(mt_rand(0, 999999999999999), 15, '0', STR_PAD_LEFT);
$orderDate       = date('Y-m-d H:i:s');
$payTypeApi      = 102;

$params = [
    'version'        => '1.0',
    'mch_id'         => $merchantId,
    'notify_url'     => $notify_url,
    'page_url'       => $page_url,
    'mch_order_no'   => $merchantOrderNo,
    'pay_type'       => $payTypeApi,
    'trade_amount'   => $amount,
    'order_date'     => $orderDate,
    'goods_name'     => 'Recharge',
    'mch_return_msg' => $merchantOrderNo
];

$params['sign'] = generateSign($params, $apiKey);
$params['sign_type'] = "MD5";

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL            => 'https://pay.sunpayonline.xyz/pay/web',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING       => '',
    CURLOPT_MAXREDIRS      => 10,
    CURLOPT_TIMEOUT        => 30,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST  => 'POST',
    CURLOPT_POSTFIELDS     => http_build_query($params),
    CURLOPT_HTTPHEADER     => ['Content-Type: application/x-www-form-urlencoded'],
]);

$response = curl_exec($curl);
if (curl_errno($curl)) {
    die('Curl error: ' . curl_error($curl));
}
curl_close($curl);

$responseData = json_decode($response, true);
if ($responseData === null) {
    die("Error: Failed to decode API response. Response was: " . $response);
}

$respCode = isset($responseData['respCode']) ? $responseData['respCode'] : 'FAIL';
$tradeMsg = isset($responseData['tradeMsg']) ? $responseData['tradeMsg'] : 'Unknown error';

if ($respCode == 'SUCCESS') {
    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        die("Database connection failed: " . $conn->connect_error);
    }

    $plan_id         = 0;
    $method_code     = 1000;
    $charge          = 0.00;
    $method_currency = 'INR';
    $rate            = 1.00;
    $final_amo       = $amount + $charge;
    $detail          = 'Payment initiated. Gateway response: ' . json_encode($responseData);
    $status          = 2;
    $payment_try     = 1;
    $from_api        = 1;
    $currentTime     = date('Y-m-d H:i:s');
    $payUrl          = isset($responseData['payInfo']) ? $responseData['payInfo'] : '';

    $sql = "INSERT INTO deposits (user_id, plan_id, method_code, amount, method_currency, charge, rate, final_amo, detail, trx, status, payment_try, from_api, created_at, updated_at)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        die("Database prepare failed: " . $conn->error);
    }

    $stmt->bind_param("iiidssddssiiiss", $userId, $plan_id, $method_code, $amount, $method_currency, $charge, $rate, $final_amo, $detail, $merchantOrderNo, $status, $payment_try, $from_api, $currentTime, $currentTime);

    if ($stmt->execute()) {
        if (!empty($payUrl)) {
            header("Location: " . $payUrl);
            exit;
        } else {
            echo "Payment page URL missing, but transaction was logged.";
        }
    } else {
        error_log("Database insert failed: " . $stmt->error);
        echo "A critical error occurred. Please contact support and provide this reference: " . $merchantOrderNo;
    }
    $stmt->close();
    $conn->close();

} else {
    echo "Payment request failed: " . htmlspecialchars($tradeMsg);
}
?>
