<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

$secretKey = "d9c774db82d94dcf827b2a8b0ecbc203";

$data = $_POST;

$requiredFields = [
    "tradeResult",
    "mchId",
    "mchOrderNo",
    "oriAmount",
    "amount",
    "orderDate",
    "orderNo",
    "signType",
    "sign"
];

foreach ($requiredFields as $field) {
    if (!isset($data[$field])) {
        error_log("Callback error: Missing field '{$field}'");
        echo "fail";
        exit;
    }
}

$tradeResult = $data['tradeResult'];
$mchId       = $data['mchId'];
$mchOrderNo  = $data['mchOrderNo'];
$oriAmount   = $data['oriAmount'];
$amount      = $data['amount'];
$orderDate   = $data['orderDate'];
$orderNo     = $data['orderNo'];
$signType    = $data['signType'];
$sign        = $data['sign'];

$merRetMsg = isset($data['merRetMsg']) ? $data['merRetMsg'] : "";

$servername = "localhost";
$dbname = "crypto36_crypto36";
$username = "crypto36_crypto36";
$password = "crypto36_crypto36";

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    error_log("Connection failed: " . $conn->connect_error);
    echo "fail";
    exit;
}

$stmt = $conn->prepare("SELECT status, user_id FROM deposits WHERE trx = ?");
$stmt->bind_param('s', $mchOrderNo);
$stmt->execute();
$stmt->bind_result($status, $userID);

if ($stmt->fetch()) {
    if ($status === 1) {
        echo "success";
        $stmt->close();
        $conn->close();
        exit;
    }
} else {
    echo "success";
    $stmt->close();
    $conn->close();
    exit;
}
$stmt->close();

$user = null;
$stmt = $conn->prepare("SELECT username FROM users WHERE id = ?");
$stmt->bind_param('s', $userID);
$stmt->execute();
$stmt->bind_result($fetchedUser);
if ($stmt->fetch()) {
    $user = $fetchedUser;
}
$stmt->close();

if ($user === null) {
    error_log("Callback error: User not found for user_id '{$userID}' with order '{$mchOrderNo}'");
    echo "fail";
    $conn->close();
    exit;
}

if ($tradeResult === "1") {
    $stmt = $conn->prepare("UPDATE deposits SET status = 1, btc_wallet = ? WHERE trx = ?");
    $stmt->bind_param('ss', $sign, $mchOrderNo);
    $stmt->execute();
    $stmt->close();

    $stmt = $conn->prepare("UPDATE users SET deposit_wallet = deposit_wallet + ? WHERE username = ?");
    $stmt->bind_param('ds', $amount, $user);
    $stmt->execute();
    $stmt->close();

    echo "success";

} elseif ($tradeResult === "2") {
    $stmt = $conn->prepare("UPDATE deposits SET status = 3, btc_wallet = ? WHERE trx = ?");
    $stmt->bind_param('ss', $sign, $mchOrderNo);
    $stmt->execute();
    $stmt->close();
    
    echo "success";

} else {
    error_log("Callback received for order '{$mchOrderNo}' with non-successful status: '{$tradeResult}'");
    echo "success";
}

$conn->close();
exit;
?>
